<?php

namespace App\Http\Controllers\api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use DB;
class HomeController extends Controller
{
    public function settingGet(){
        $setting = DB::table('settings')->select('frontend_img_url','color','vat')->first();
        return response()->json([
            'setting'=>$setting,
        ]);
    }
    public function HomePage(){
        $ReadyProducts = DB::table('products')->where('stock','>',0)->select('type','product_name','selling_price','min_order','code','created_at','stock')->paginate(10);
        $SampleProducts = DB::table('products')->where('stock','<=',0)->select('type','product_name','highest_price','lowest_price','selling_price','min_order','code','created_at')->paginate(10);
        return response()->json([
            'ReadyProducts'=>$ReadyProducts,
            'SampleProducts'=>$SampleProducts,
        ]);
    }
    public function HomePageReady($sortBy){
        $ReadyProducts = DB::table('products')->where('stock','>',0)->orderBy('id',$sortBy)->select('id','type','product_name','selling_price','min_order','code','created_at','stock')->paginate(10);
        foreach($ReadyProducts as $ReadyProduct){
            $readyProdutImage[] = DB::table('images')->where(['product_id'=>$ReadyProduct->id])->orderBy('id','ASC')->select('name')->first();
        }
        return response()->json([
            'ReadyProducts'=>$ReadyProducts,
            'readyProductImage'=>$readyProdutImage
        ]);
    }
    public function HomePageSample($sortBy){
        $SampleProducts = DB::table('products')->where('stock','<=',0)->orderBy('id',$sortBy)->select('id','type','product_name','highest_price','lowest_price','selling_price','min_order','code','created_at')->paginate(10);
        foreach($SampleProducts as $ReadyProduct){
            $readyProdutImage[] = DB::table('images')->where(['product_id'=>$ReadyProduct->id])->orderBy('id','ASC')->select('name')->first();
        }
        return response()->json([
            'SampleProducts'=>$SampleProducts,
            'sampleProductImage'=>$readyProdutImage
        ]);
    }
}
