<?php

namespace App\Http\Controllers\api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use DB;
class CategoryController extends Controller
{
    public function MainCategoryProduct(Request $request, $id, $asc, $highLow){
        $productCount= DB::table('products')->where(['category_id'=>$id])->orderBy('id','DESC')->select('type','id','product_name','highest_price','lowest_price','selling_price','min_order','code','created_at','stock')->where(['status'=>1])->count();
        if($productCount == 0){
            return response()->json([
                'success'=>false,
            ]);
        }
        $currentSize = $request->size;
        if($currentSize != 'all'){
        //    $productAttributes = DB::table('product_attributes')
        //     ->join('products', 'product_attributes.product_id', '=', 'products.id')
        //     ->select(
        //         'product_attributes.*',
        //         'products.product_name',
        //         'products.category_id'
        //     )
        //     ->where(['size'=>$currentSize])->orderBy('product_name',$asc)->orderBy('selling_price',$highLow)->paginate();
            if($asc == 'DESC'){
                $product = DB::table('product_attributes')
                ->join('products', 'product_attributes.product_id', '=', 'products.id')
                ->select(
                    'product_attributes.*',
                    'products.product_name',
                    'products.category_id'
                )
                ->where(['size'=>$currentSize])->orderBy('product_name',$asc)->orderBy('selling_price',$highLow)->paginate();
            }else if($highLow == 'DESC'){
                $product = DB::table('product_attributes')
                ->join('products', 'product_attributes.product_id', '=', 'products.id')
                ->select(
                    'product_attributes.*',
                    'products.product_name',
                    'products.category_id'
                )
                ->where(['size'=>$currentSize])->orderBy('selling_price',$highLow)->orderBy('product_name',$asc)->paginate();
            }else{
                $product = DB::table('product_attributes')
                ->join('products', 'product_attributes.product_id', '=', 'products.id')
                ->select(
                    'product_attributes.*',
                    'products.product_name',
                    'products.category_id',
                    'products.code'
                )
                ->where(['size'=>$currentSize])->orderBy('product_name',$asc)->orderBy('selling_price',$highLow)->paginate();
            }
            foreach($product as $ddd){
                $ProdutImage[] = $ddd->image;
            }
            $productAttributeSize = [];
            $produdddct = DB::table('products')->where(['category_id'=>$id])->select('id')->get();
            foreach ($produdddct as $prod) {
                // product_attributes টেবিল থেকে product_id অনুযায়ী সব size নিয়ে আসছি
                $sizes = DB::table('product_attributes')
                    ->where('product_id', $prod->id)
                    ->pluck('size');

                // sizes থেকে প্রতিটা size ট্রিম করে অ্যারেতে push করছি
                foreach ($sizes as $size) {
                    $productAttributeSize[] = trim($size);
                }
            }

            // এখন Laravel Collection ব্যবহার করে ডুপ্লিকেট বাদ দিলাম
            $productAttributeSize = collect($productAttributeSize)->unique()->values()->all();

            foreach($product as $ReadyProduct){
                $ProdutImage[] = DB::table('images')->where(['product_id'=>$ReadyProduct->id])->orderBy('id','ASC')->select('name')->first();
            }
            return response()->json([
                'data'=>$product,
                'ProdutImage'=>$ProdutImage,
                'productAttributeSize'=>$productAttributeSize,
                'currentSize'=>$currentSize,
                'success'=>true
            ]);
        }
        if($asc == 'DESC'){
            $product = DB::table('products')->where(['category_id'=>$id])->orderBy('product_name',$asc)->orderBy('selling_price',$highLow)->select('type','id','product_name','highest_price','lowest_price','selling_price','min_order','code','created_at','stock')->where(['status'=>1])->paginate(10);
        }else if($highLow == 'DESC'){
            $product = DB::table('products')->where(['category_id'=>$id])->orderBy('selling_price',$highLow)->orderBy('product_name',$asc)->select('type','id','product_name','highest_price','lowest_price','selling_price','min_order','code','created_at','stock')->where(['status'=>1])->paginate(10);
        }else{
            $product = DB::table('products')->where(['category_id'=>$id])->orderBy('product_name',$asc)->orderBy('selling_price',$highLow)->select('type','id','product_name','highest_price','lowest_price','selling_price','min_order','code','created_at','stock')->where(['status'=>1])->paginate(10);
        }
        $productAttributeSize = [];
        foreach ($product as $prod) {
            // product_attributes টেবিল থেকে product_id অনুযায়ী সব size নিয়ে আসছি
            $sizes = DB::table('product_attributes')
                ->where('product_id', $prod->id)
                ->pluck('size');

            // sizes থেকে প্রতিটা size ট্রিম করে অ্যারেতে push করছি
            foreach ($sizes as $size) {
                $productAttributeSize[] = trim($size);
            }
        }

        // এখন Laravel Collection ব্যবহার করে ডুপ্লিকেট বাদ দিলাম
        $productAttributeSize = collect($productAttributeSize)->unique()->values()->all();

        foreach($product as $ReadyProduct){
            $ProdutImage[] = DB::table('images')->where(['product_id'=>$ReadyProduct->id])->orderBy('id','ASC')->select('name')->first();
        }
        return response()->json([
            'data'=>$product,
            'ProdutImage'=>$ProdutImage,
            'productAttributeSize'=>$productAttributeSize,
            'currentSize'=>$currentSize,
            'success'=>true
        ]);
    }
    public function SubCategoryProduct($id, $asc, $highLow){
        $productCount= DB::table('products')->where(['sub_category_id'=>$id])->orderBy('id','DESC')->select('type','id','product_name','highest_price','lowest_price','selling_price','min_order','code','created_at','stock')->count();
        if($productCount == 0){
            return response()->json([
                'success'=>false,
                'ProdutImage'=>$ProdutImage,
            ]);
        }
        if($highLow == 'default'){
            $product = DB::table('products')->where(['sub_category_id'=>$id])->orderBy('id',$asc)->select('type','id','product_name','highest_price','lowest_price','selling_price','min_order','code','created_at','stock')->paginate(10);   
        }else{
            $product = DB::table('products')->where(['sub_category_id'=>$id])->orderBy('selling_price',$highLow)->select('type','id','product_name','highest_price','lowest_price','selling_price','min_order','code','created_at','stock')->paginate(10);   
        }
        foreach($product as $ReadyProduct){
            $ProdutImage[] = DB::table('images')->where(['product_id'=>$ReadyProduct->id])->orderBy('id','ASC')->select('name')->first();
        }
        return response()->json([
            'data'=>$product,
            'ProdutImage'=>$ProdutImage,
            'success'=>true
        ]);
    }
}
