<?php

namespace App\Http\Controllers\api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use DB;

class OrderController extends Controller
{
    public function getOrders($tokenId){
        $authTokenID = DB::table('personal_access_tokens')->where(['id'=>$tokenId])->first();
        $userId = DB::table('users')->where(['id'=>$authTokenID->tokenable_id])->first();
        $orders = DB::table('orders')->where(['user_id'=>$userId->id])->orWhere(['customer_phone_no'=>$userId->phone])->orderBy('id','DESC')->paginate(15);
            return response()->json([
                'success'=>true,
                'data'=>$orders,
                'user'=>$userId,
            ]);
        
    }
    public function orderProductGet($orderId){
        $order = DB::table('orders')->where(['id'=>$orderId])->first();
        $order_products = DB::table('order_products')->where(['order_id'=>$order->id])->get();
        return response()->json([
            'success'=>false,
            'order'=>$order,
            'orderProducts'=>$order_products
        ]);
    }
}
