<?php

namespace App\Http\Controllers\api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use DB;
use Auth;
use Hash;

class UserController extends Controller
{
    public function TotalOrder($token){
        $auth = Auth::user()->id;
        $orders = DB::table('orders')->orderBy('id','DESC')->where('user_id', $auth)->select('id','order_id','date_time','total_amount','status')->paginate(15);
        foreach($orders as $key => $order) {
            $order->date_time = date('d M Y', strtotime($order->date_time));
            $order->status = match($order->status) {
                1 => 'Approved',
                2 => 'New Order',
                3 => 'Shipment',
                4 => 'Cancel',
                5 => 'Authorized',
                6 => 'Delivered',
                8 => 'Pending',
                default => 'Unknown'
            };
            $items[] = DB::table('order_products')->where(['order_id'=>$order->id])->select('image')->get();
        }
        
        return response()->json([
            'order'=>$orders,
            'items'=>$items ?? [],
            'user'=>Auth::user(),
            'success'=>true,
            'message'=>'Order list retrieved successfully.'
        ])->setStatusCode(200, 'OK');
    }
    public function AuthUserCheckAccountInformation(){
        $user = Auth::user();
        return response()->json([
            'user'=>$user,
        ]);
    }
    public function UpdateUserAccount(Request $request){
        $user = Auth::user();
        $data = $request->validate([
            'name' => 'required|string|max:255',
            'email' => 'required|email|max:255|unique:users,email,'.$user->id,
            'phone' => 'required|string|max:11|unique:users,phone,'.$user->id,
        ]);

        $user->update($data);

        return response()->json([
            'message' => 'User account updated successfully.',
            'user' => $user
        ])->setStatusCode(200, 'OK');
    }
    public function DashboardPageData(){
        $totalOrder = DB::table('orders')->count();
        $completeOrder = DB::table('orders')->where(['status'=>5])->count();
        $totalQuote = DB::table('quotes')->count();
        return response()->json([
            'totalOrder'=>$totalOrder,
            'completeOrder'=>$completeOrder,
            'totalQuote'=>$totalQuote,
            'user'=>Auth::user(),
        ]);
    }
    public function ChangePassword(Request $request){
        return $request->all();
        if(Hash::check($request->currentPassword, $user->password) == true){
            DB::table('users')->where(['id'=>Auth::user()->id])->update(['password'=>Hash::make($request->newPassword)]);
            return response()->json([
                'success'=>true,
                'message'=>'Success',
            ]);
        }
        return $user;
        $data = $request->validate([
            'currentPassword' => 'required|string',
            'newPassword' => 'required|string|min:8|confirmed',
        ]);

        if (!password_verify($data['currentPassword'], $user->password)) {
            return response()->json(['message' => 'Current password is incorrect.'], 400);
        }

        $user->password = bcrypt($data['newPassword']);
        $user->save();

        return response()->json(['message' => 'Password changed successfully.'], 200);
    }
    public function UserLogout(){
        Auth::logout();
        return response()->json([
            'success'=>true,
            'message'=>'User logged out successfully.'
        ])->setStatusCode(200, 'OK');
    }
}
