import {
  __esm,
  __export
} from "./chunk-NIBQISYW.js";

// node_modules/@vue/devtools-api/lib/esm/env.js
function getDevtoolsGlobalHook() {
  return getTarget().__VUE_DEVTOOLS_GLOBAL_HOOK__;
}
function getTarget() {
  return typeof navigator !== "undefined" && typeof window !== "undefined" ? window : typeof global !== "undefined" ? global : {};
}
var isProxyAvailable;
var init_env = __esm({
  "node_modules/@vue/devtools-api/lib/esm/env.js"() {
    isProxyAvailable = typeof Proxy === "function";
  }
});

// node_modules/@vue/devtools-api/lib/esm/const.js
var HOOK_SETUP, HOOK_PLUGIN_SETTINGS_SET;
var init_const = __esm({
  "node_modules/@vue/devtools-api/lib/esm/const.js"() {
    HOOK_SETUP = "devtools-plugin:setup";
    HOOK_PLUGIN_SETTINGS_SET = "plugin:settings:set";
  }
});

// node_modules/@vue/devtools-api/lib/esm/time.js
function isPerformanceSupported() {
  var _a;
  if (supported !== void 0) {
    return supported;
  }
  if (typeof window !== "undefined" && window.performance) {
    supported = true;
    perf = window.performance;
  } else if (typeof global !== "undefined" && ((_a = global.perf_hooks) === null || _a === void 0 ? void 0 : _a.performance)) {
    supported = true;
    perf = global.perf_hooks.performance;
  } else {
    supported = false;
  }
  return supported;
}
function now() {
  return isPerformanceSupported() ? perf.now() : Date.now();
}
var supported, perf;
var init_time = __esm({
  "node_modules/@vue/devtools-api/lib/esm/time.js"() {
  }
});

// node_modules/@vue/devtools-api/lib/esm/proxy.js
var ApiProxy;
var init_proxy = __esm({
  "node_modules/@vue/devtools-api/lib/esm/proxy.js"() {
    init_const();
    init_time();
    ApiProxy = class {
      constructor(plugin, hook) {
        this.target = null;
        this.targetQueue = [];
        this.onQueue = [];
        this.plugin = plugin;
        this.hook = hook;
        const defaultSettings = {};
        if (plugin.settings) {
          for (const id in plugin.settings) {
            const item = plugin.settings[id];
            defaultSettings[id] = item.defaultValue;
          }
        }
        const localSettingsSaveId = `__vue-devtools-plugin-settings__${plugin.id}`;
        let currentSettings = Object.assign({}, defaultSettings);
        try {
          const raw = localStorage.getItem(localSettingsSaveId);
          const data = JSON.parse(raw);
          Object.assign(currentSettings, data);
        } catch (e) {
        }
        this.fallbacks = {
          getSettings() {
            return currentSettings;
          },
          setSettings(value) {
            try {
              localStorage.setItem(localSettingsSaveId, JSON.stringify(value));
            } catch (e) {
            }
            currentSettings = value;
          },
          now() {
            return now();
          }
        };
        if (hook) {
          hook.on(HOOK_PLUGIN_SETTINGS_SET, (pluginId, value) => {
            if (pluginId === this.plugin.id) {
              this.fallbacks.setSettings(value);
            }
          });
        }
        this.proxiedOn = new Proxy({}, {
          get: (_target, prop) => {
            if (this.target) {
              return this.target.on[prop];
            } else {
              return (...args) => {
                this.onQueue.push({
                  method: prop,
                  args
                });
              };
            }
          }
        });
        this.proxiedTarget = new Proxy({}, {
          get: (_target, prop) => {
            if (this.target) {
              return this.target[prop];
            } else if (prop === "on") {
              return this.proxiedOn;
            } else if (Object.keys(this.fallbacks).includes(prop)) {
              return (...args) => {
                this.targetQueue.push({
                  method: prop,
                  args,
                  resolve: () => {
                  }
                });
                return this.fallbacks[prop](...args);
              };
            } else {
              return (...args) => {
                return new Promise((resolve) => {
                  this.targetQueue.push({
                    method: prop,
                    args,
                    resolve
                  });
                });
              };
            }
          }
        });
      }
      async setRealTarget(target) {
        this.target = target;
        for (const item of this.onQueue) {
          this.target.on[item.method](...item.args);
        }
        for (const item of this.targetQueue) {
          item.resolve(await this.target[item.method](...item.args));
        }
      }
    };
  }
});

// node_modules/@vue/devtools-api/lib/esm/api/api.js
var init_api = __esm({
  "node_modules/@vue/devtools-api/lib/esm/api/api.js"() {
  }
});

// node_modules/@vue/devtools-api/lib/esm/api/app.js
var init_app = __esm({
  "node_modules/@vue/devtools-api/lib/esm/api/app.js"() {
  }
});

// node_modules/@vue/devtools-api/lib/esm/api/component.js
var init_component = __esm({
  "node_modules/@vue/devtools-api/lib/esm/api/component.js"() {
  }
});

// node_modules/@vue/devtools-api/lib/esm/api/context.js
var init_context = __esm({
  "node_modules/@vue/devtools-api/lib/esm/api/context.js"() {
  }
});

// node_modules/@vue/devtools-api/lib/esm/api/hooks.js
var init_hooks = __esm({
  "node_modules/@vue/devtools-api/lib/esm/api/hooks.js"() {
  }
});

// node_modules/@vue/devtools-api/lib/esm/api/util.js
var init_util = __esm({
  "node_modules/@vue/devtools-api/lib/esm/api/util.js"() {
  }
});

// node_modules/@vue/devtools-api/lib/esm/api/index.js
var init_api2 = __esm({
  "node_modules/@vue/devtools-api/lib/esm/api/index.js"() {
    init_api();
    init_app();
    init_component();
    init_context();
    init_hooks();
    init_util();
  }
});

// node_modules/@vue/devtools-api/lib/esm/plugin.js
var init_plugin = __esm({
  "node_modules/@vue/devtools-api/lib/esm/plugin.js"() {
  }
});

// node_modules/@vue/devtools-api/lib/esm/index.js
var esm_exports = {};
__export(esm_exports, {
  isPerformanceSupported: () => isPerformanceSupported,
  now: () => now,
  setupDevtoolsPlugin: () => setupDevtoolsPlugin
});
function setupDevtoolsPlugin(pluginDescriptor, setupFn) {
  const descriptor = pluginDescriptor;
  const target = getTarget();
  const hook = getDevtoolsGlobalHook();
  const enableProxy = isProxyAvailable && descriptor.enableEarlyProxy;
  if (hook && (target.__VUE_DEVTOOLS_PLUGIN_API_AVAILABLE__ || !enableProxy)) {
    hook.emit(HOOK_SETUP, pluginDescriptor, setupFn);
  } else {
    const proxy = enableProxy ? new ApiProxy(descriptor, hook) : null;
    const list = target.__VUE_DEVTOOLS_PLUGINS__ = target.__VUE_DEVTOOLS_PLUGINS__ || [];
    list.push({
      pluginDescriptor: descriptor,
      setupFn,
      proxy
    });
    if (proxy)
      setupFn(proxy.proxiedTarget);
  }
}
var init_esm = __esm({
  "node_modules/@vue/devtools-api/lib/esm/index.js"() {
    init_env();
    init_const();
    init_proxy();
    init_api2();
    init_plugin();
    init_time();
  }
});

export {
  setupDevtoolsPlugin,
  esm_exports,
  init_esm
};
//# sourceMappingURL=chunk-FQDAIJCM.js.map
