import { ConfigurableDocument, MaybeRefOrGetter } from '@vueuse/core';
import Sortable, { Options } from 'sortablejs';

interface UseSortableReturn {
    /**
     * start sortable instance
     */
    start: () => void;
    /**
     * destroy sortable instance
     */
    stop: () => void;
    /**
     * Options getter/setter
     * @param name a Sortable.Options property.
     * @param value a value.
     */
    option: (<K extends keyof Sortable.Options>(name: K, value: Sortable.Options[K]) => void) & (<K extends keyof Sortable.Options>(name: K) => Sortable.Options[K]);
}
type UseSortableOptions = Options & ConfigurableDocument;
declare function useSortable<T>(selector: string, list: MaybeRefOrGetter<T[]>, options?: UseSortableOptions): UseSortableReturn;
declare function useSortable<T>(el: MaybeRefOrGetter<HTMLElement | null | undefined>, list: MaybeRefOrGetter<T[]>, options?: UseSortableOptions): UseSortableReturn;
declare function moveArrayElement<T>(list: MaybeRefOrGetter<T[]>, from: number, to: number): void;

export { type UseSortableOptions, type UseSortableReturn, moveArrayElement, useSortable };
