import type { ComputedRef, Ref, TransitionProps } from 'vue';
import type VueFinalModal from './VueFinalModal.vue';
export declare enum TransitionState {
    Enter = 0,
    Entering = 1,
    Leave = 2,
    Leaving = 3
}
type TransitionListeners = {
    beforeEnter: () => void;
    afterEnter: () => void;
    beforeLeave: () => void;
    afterLeave: () => void;
};
export declare function useTransition(props: InstanceType<typeof VueFinalModal>['$props'], options: {
    modelValueLocal: Ref<boolean>;
    onEntering?: () => void;
    onEnter?: () => void;
    onLeaving?: () => void;
    onLeave?: () => void;
}): {
    visible: Ref<boolean>;
    contentVisible: Ref<boolean>;
    contentListeners: TransitionListeners;
    contentTransition: ComputedRef<TransitionProps>;
    overlayVisible: Ref<boolean>;
    overlayListeners: TransitionListeners;
    overlayTransition: ComputedRef<TransitionProps>;
    enterTransition: () => void;
    leaveTransition: () => void;
};
export {};
