'use strict';var vue=require('vue');function _slicedToArray(arr, i) {
  return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest();
}

function _arrayWithHoles(arr) {
  if (Array.isArray(arr)) return arr;
}

function _iterableToArrayLimit(arr, i) {
  if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return;
  var _arr = [];
  var _n = true;
  var _d = false;
  var _e = undefined;

  try {
    for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
      _arr.push(_s.value);

      if (i && _arr.length === i) break;
    }
  } catch (err) {
    _d = true;
    _e = err;
  } finally {
    try {
      if (!_n && _i["return"] != null) _i["return"]();
    } finally {
      if (_d) throw _e;
    }
  }

  return _arr;
}

function _unsupportedIterableToArray(o, minLen) {
  if (!o) return;
  if (typeof o === "string") return _arrayLikeToArray(o, minLen);
  var n = Object.prototype.toString.call(o).slice(8, -1);
  if (n === "Object" && o.constructor) n = o.constructor.name;
  if (n === "Map" || n === "Set") return Array.from(o);
  if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen);
}

function _arrayLikeToArray(arr, len) {
  if (len == null || len > arr.length) len = arr.length;

  for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i];

  return arr2;
}

function _nonIterableRest() {
  throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
}var script = vue.defineComponent({
  name: "Vue3Autocounter",
  interval: null,
  props: {
    startAmount: {
      type: Number,
      default: 0
    },
    endAmount: {
      type: Number,
      default: 0,
      required: true
    },
    duration: {
      type: Number,
      default: 3,
      validator: function validator(duration) {
        return duration >= 1;
      }
    },
    autoinit: {
      type: Boolean,
      default: true
    },
    prefix: {
      type: String,
      default: ''
    },
    suffix: {
      type: String,
      default: ''
    },
    separator: {
      type: String,
      default: ','
    },
    decimalSeparator: {
      type: String,
      default: '.'
    },
    decimals: {
      type: Number,
      default: 0,
      validator: function validator(decimals) {
        return decimals >= 0;
      }
    }
  },
  data: function data() {
    return {
      timestamp: 0,
      startTimestamp: 0,
      currentAmount: 0,
      currentStartAmount: 0,
      currentDuration: 0,
      paused: false,
      remaining: 0,
      animationFrame: 0
    };
  },
  mounted: function mounted() {
    this.currentAmount = this.startAmount;
    this.currentStartAmount = this.startAmount;
    this.currentDuration = this.duration * 1000;
    this.remaining = this.duration * 1000;
    if (this.autoinit) this.start();else this.paused = true;
    this.$emit('mounted');
  },
  unmounted: function unmounted() {
    this.cancelAnimation();
  },
  watch: {
    startAmount: function startAmount() {
      this.reset();
    },
    endAmount: function endAmount() {
      this.reset();
    },
    duration: function duration() {
      this.reset();
    }
  },
  computed: {
    isCountingUp: function isCountingUp() {
      return this.endAmount > this.startAmount;
    },
    displayedAmount: function displayedAmount() {
      return "".concat(this.prefix).concat(this.formatedAmount).concat(this.suffix);
    },
    formatedAmount: function formatedAmount() {
      var regex = /(\d+)(\d{3})/;
      var numberString = this.currentAmount.toFixed(this.decimals);
      numberString += '';
      var numberArray = numberString.split('.');
      var numbers = numberArray[0];
      var decimals = numberArray.length > 1 ? this.decimalSeparator + numberArray[1] : '';
      var isNumber = !isNaN(parseFloat(this.separator));

      if (this.separator && !isNumber) {
        while (regex.test(numbers)) {
          numbers = numbers.replace(regex, '$1' + this.separator + '$2');
        }
      }

      return numbers + decimals;
    }
  },
  methods: {
    start: function start() {
      this.cancelAnimation();
      this.currentStartAmount = this.startAmount;
      this.startTimestamp = null;
      this.currentDuration = this.duration * 1000;
      this.paused = false;
      this.animationFrame = window.requestAnimationFrame(this.counting);
    },
    pause: function pause() {
      if (this.paused) return;
      this.cancelAnimation();
      this.paused = true;
    },
    resume: function resume() {
      if (!this.paused) return;
      this.startTimestamp = null;
      this.currentDuration = +this.remaining;
      this.currentStartAmount = +this.currentAmount;
      this.animationFrame = window.requestAnimationFrame(this.counting);
      this.paused = false;
    },
    reset: function reset() {
      this.paused = false;
      this.startTimestamp = null;
      this.cancelAnimation();
      this.currentAmount = this.startAmount;
      if (this.autoinit) this.start();else this.paused = true;
    },
    counting: function counting(timestamp) {
      var _this = this;

      this.timestamp = timestamp;
      if (!this.startTimestamp) this.startTimestamp = timestamp;
      var progress = timestamp - this.startTimestamp;
      this.remaining = this.currentDuration - progress;

      if (!this.isCountingUp) {
        this.currentAmount = this.currentStartAmount - (this.currentStartAmount - this.endAmount) * (progress / this.currentDuration);
        this.currentAmount = this.currentAmount < this.endAmount ? this.endAmount : this.currentAmount;
      } else {
        this.currentAmount = this.currentStartAmount + (this.endAmount - this.currentStartAmount) * (progress / this.currentDuration);
        this.currentAmount = this.currentAmount > this.endAmount ? this.endAmount : this.currentAmount;
      }

      if (progress < this.currentDuration) this.animationFrame = window.requestAnimationFrame(this.counting);else {
        setTimeout(function () {
          _this.$emit('finished');
        }, 1000);
      }
    },
    cancelAnimation: function cancelAnimation() {
      if (this.animationFrame) window.cancelAnimationFrame(this.animationFrame);
    }
  }
});function render(_ctx, _cache, $props, $setup, $data, $options) {
  return vue.openBlock(), vue.createBlock("span", null, vue.toDisplayString(_ctx.displayedAmount), 1);
}script.render = render;// Import vue component

// Default export is installable instance of component.
// IIFE injects install function into component, allowing component
// to be registered via Vue.use() as well as Vue.component(),
var component = /*#__PURE__*/(function () {
  // Assign InstallableComponent type
  var installable = script; // Attach install function executed by Vue.use()

  installable.install = function (app) {
    app.component('Vue3Autocounter', installable);
  };

  return installable;
})(); // It's possible to expose named exports when writing components that can
// also be used as directives, etc. - eg. import { RollupDemoDirective } from 'rollup-demo';
// export const RollupDemoDirective = directive;
var namedExports=/*#__PURE__*/Object.freeze({__proto__:null,'default': component});// only expose one global var, with named exports exposed as properties of
// that global var (eg. plugin.namedExport)

Object.entries(namedExports).forEach(function (_ref) {
  var _ref2 = _slicedToArray(_ref, 2),
      exportName = _ref2[0],
      exported = _ref2[1];

  if (exportName !== 'default') component[exportName] = exported;
});module.exports=component;