
import {createRouter, createWebHistory, routeLocationKey} from "vue-router";


const routes=[
    {
        path: '/:pathMatch(.*)*',
        name:'notFound',
        component : () => import('../component/notFound.vue'),
        meta:{
            title:"Not Found | ",
        }
    },
    {
        path:'/',
        name:'home',
        component : () => import('../component/page/home.vue'),
        meta:{
            title:'',
        }
    },
    {
        path:'/samples',
        name:'Samples',
        component : () => import('../component/page/webPage/sample.vue'),
        meta:{
            title:'Samples | '+'',
        }
    },
    {
        path:'/in-stock',
        name:'INSTOCK',
        component : () => import('../component/page/webPage/in_stock.vue'),
        meta:{
            title:'In Stock | '+'',
        }
    },
    {
        path:'/category/:categoryName',
        name:'Category',
        component : () => import('../component/page/category/mainCategory.vue'),
        meta:{
            title:'Category | '+'',
        }
    },
        {
        path:'/category/sample/:categoryName',
        name:'SampleCategory',
        component : () => import('../component/page/category/mainCategorySample.vue'),
        meta:{
            title:'Category Sample | '+'',
        }
    },
    {
        path:'/test',
        name:'Test',
        component : () => import('../component/page/test.vue'),
        meta:{
            title:'',
        }
    },
    {
        path:'/category/:mainCategory/:categoryName',
        name:'SubCategory',
        component : () => import('../component/page/category/subCategory.vue'),
        meta:{
            title:'',
        }
    },


    // End new Route end
    {
        path:'/products',
        name:'Shop',
        component : () => import('../component/page/shop.vue'),
        meta:{
            title:'Shop | ',
        }
    },
    {
        path:'/products/:product_id/:product_url',
        name:'ProductDetails',
        component : () => import('../component/page/product_details.vue'),
        meta:{
            title:'',
        }
    },
    {
        path:'/carts',
        name:'Carts',
        component : () => import('../component/page/cart.vue'),
        meta:{
            title:'Carts | ',
        }
    },
    {
        path:'/order/order-confirmation/:orderId',
        name:'OrderConfirmation',
        component : () => import('../component/page/user/order_confirmation.vue'),
        meta:{
            title:'Confirm Order | ',
        }
    },
    {
        path:'/checkout',
        name:'Checkout',
        component : () => import('../component/page/checkout.vue'),
        meta:{
            title: 'Checkout | ',
        }
    },
    {
        path:'/payment/:id/:orderId',
        name:'Payment',
        component : () => import('../component/page/payment.vue'),
        meta:{
            title: 'Payment | ',
        }
    },
    {
        path:'/payment/:id/:orderId/:amount',
        name:'CustomPayment',
        component : () => import('../component/page/custom_payment.vue'),
        meta:{
            title: 'Custom Payment | ',
        }
    },
    {
        path:'/login',
        name:'Login',
        component : () => import('../component/page/auth/login.vue'),
        meta:{
            title:'Login | '+'',
            requiresAuth:false,
        }
    },
    {
        path:'/quote-form/:productId',
        name:'QuoteForm',
        component : () => import('../component/page/quote_form.vue'),
        meta:{
            title:'Quote Form | '+'',
        }
    },
    {
        path:'/quote-form',
        name:'QuoteFormN',
        component : () => import('../component/page/quote_formn.vue'),
        meta:{
            title:'Quote Form | '+'',
        }
    },
    {
        path:'/order-success/:id',
        name:'OrderSuccess',
        component : () => import('../component/page/order/order_success.vue'),
        meta:{
            title:'Order Success | '+'',
        }
    },
    {
        path:'/forgot-password',
        name:'ForgotPassword',
        component : () => import('../component/page/auth/forgot_password.vue'),
        meta:{
            title:'Forgot Password | '+'',
            requiresAuth:false,
        }
    },
    {
        path:'/register',
        name:'Register',
        component : () => import('../component/page/auth/register.vue'),
        meta:{
            title:'Register | '+'',
            requiresAuth:false,
        }
    },
    {
        path:'/verify-phone/:phone/:session',
        name:'VerifyPin',
        component : () => import('../component/page/auth/verify_pin.vue'),
        meta:{
            title:'Verify Phone | '+'',
        }
    },
    {
        path:'/change-password',
        name:'changePassword',
        component : () => import('../component/page/auth/change_password.vue'),
        meta:{
            title:'Change Password | '+'',
            requiresAuth:true,
        }
    },
    {
        path:'/payment-history',
        name:'Payment History',
        component : () => import('../component/page/user/payment_history.vue'),
        meta:{
            title:'Payment History | '+'',
            requiresAuth:true,
        }
    },
    {
        path:'/orders',
        name:'Your Orders',
        component : () => import('../component/page/user/orders.vue'),
        meta:{
            title:'Orders | '+'',
            requiresAuth:true,
        }
    },
    {
        path:'/customer/profile',
        name:'YourFrofile',
        component : () => import('../component/page/user/profile.vue'),
        meta:{
            title:'Profile | '+'',
            requiresAuth:true,
        }
    },
        {
        path:'/user/dashboard',
        name:'userDashboard',
        component : () => import('../component/page/user/userDashboard.vue'),
        meta:{
            title:'User Dashboard | '+'',
            requiresAuth:true,
        }
    },
    {
        path:'/about-us',
        name:'About Us',
        component : () => import('../component/page/webPage/about.vue'),
        meta:{
            title:'About | '+'',
        }
    },
        {
        path:'/company-profile',
        name:'CompanyProfile',
        component : () => import('../component/page/webPage/company_profile.vue'),
        meta:{
            title:'Company Profile | '+'',
        }
    },
    {
        path:'/contact-us',
        name:'Contact Us',
        component : () => import('../component/page/webPage/contact.vue'),
        meta:{
            title:'Contact | '+'',
        }
    },
    {
        path:'/faq',
        name:'FAQ',
        component : () => import('../component/page/webPage/faq.vue'),
        meta:{
            title:'FAQ | '+'',
        }
    },
    {
        path:'/privacy-policy',
        name:'Privacy Policy',
        component : () => import('../component/page/webPage/privacy_policy.vue'),
        meta:{
            title:'Privacy Policy | '+'',
        }
    },
    {
        path:'/team',
        name:'TEAM',
        component : () => import('../component/page/webPage/team.vue'),
        meta:{
            title:'Team | '+'',
        }
    },
    {
        path:'/terms-and-conditions',
        name:'Terms Condition',
        component : () => import('../component/page/webPage/terms&condition.vue'),
        meta:{
            title:'Terms & Condition | '+'',
        }
    },
    {
        path:'/search/:SearchText',
        name:'Search Product',
        component : () => import('../component/page/SearchProduct.vue'),
        meta:{
            title:'Search : ' + '',
        }
    },

]

const router = createRouter({
    history:createWebHistory(),
    routes,
})

router.beforeEach((to, from)=>{
    if(to.meta.requiresAuth == true && !localStorage.getItem('HolesaleBagauthToken')){
        return { name:'Login' }
    }
    if(to.meta.requiresAuth == false && localStorage.getItem('HolesaleBagauthToken')){
        return {name:'home'}
    }
    if(to.params.SearchText){
        document.title = 'Search : '+to.params.SearchText+' | WholeSaleBagBd';
    }else if(to.params.product_id){
        document.title = 'product details';
    }else if(to.params.categoryProduct){
        axios.post('/api/cat-check/'+to.params.categoryProduct).then(response =>{
            if(response.data.data == false){
                document.title = to.params.categoryProduct+' | ' + response.data.title
            }else{
                document.title = response.data.data+' | ' + response.data.title
            }
            
        })
    }else{
        axios.post('/api/title-check').then(response =>{
            document.title = to.meta.title + response.data.data.home_title
        })
    }
})
router.afterEach((to) => {
  if (window.dataLayer) {
    window.dataLayer.push({
      event: 'page_view',
      page_path: to.fullPath,
      page_name: to.name || 'unknown'
    })
  }
  console.log(window.dataLayer)
})

export default router;
