import { createStore } from 'vuex'


export default createStore({
    state: {
        subCategory:[],
        parentCategory: [],
        colors: [],
        sizes: [],
        products:[],
        parentProducts:[],
        extra_categories:[],
        cart:[],
        compare:[],
        cartSum:[],
        settings:[],
        couponAmount:0,
        orders:[],
        CartCompare:'0',
        user:[],
        country:[],
        loader:false,
        sliders:[],
        UserLogged:false,
        SearchProduct:[],
        SearchProductImage:[],
        nextSearchUrl:[],
        parentProduct:[],
        SearchText:'',
        SearchLoader:false,
        mainPage:[],
        mainPageLoader:false,
        mobileMenuHideShow:false,
        LeftCategorySidebar:true,
        rightSidebar:false,
        rightCompare:true,
        SubNavClose:false,
        MainNav:[],
        subNavData:[],
        categoryProduct:[],
        categoryImage:[],
        NextPageUrl:'',
        CategoryLoader:false,
        hot_product:[],
        categorySlug:'',
        ReadyProducts:[],
        ReadyProductNextPage:'',
        ReadyProductImage:[],
        SampleProducts:[],
        SampleProductNextPage:'',
        SampleProductImage:[],
        homeSlider:[],
        HeaderFooterOff:true,
        HeaderSearchbar:true,
        searchInstock:'stock',
        CurrentTab:'dashboard',
        CurrentOrderId:0,
    },
    mutations: {
        Homepage(state, data){
            state.parentCategory = data.parentCategory
            state.subCategory = data.subCategory
            state.sliders = data.sliders
        },
        Products(state, data){
            data.subCategoryProduct.map((prod, index)=>{
                state.products.push(prod)
                state.parentProducts.push(data.categoryWiseProduct[index])
                state.extra_categories.push(data.extra_categories.data[index])
            })
        },
        ProductsCategoriesNull(state){
            state.products = []
            state.parentProducts = []
            state.extra_categories = []
        },
        colorChanges(state, id){
            state.colors.map((col)=>{
                if(col.id == id){
                    if(col.active == 1){
                        col.active = 0
                    }else{
                        col.active = 1
                    }
                }
            })
        },
        cartItem(state, data){
            state.cart = data.cartItem
            state.compare = data.compareItem
            state.cartSum = data.cartcount
        },
        addCart(state, data){
            state.cart.push(data.data)
            state.cartSum = parseFloat(state.cartSum) + parseFloat(data.data.total_price)
        },
        addCompare(state, data){
            state.compare.push(data)
        },
        SizeColor(state, data){
            state.colors = data.colors
            state.sizes = data.sizes
        },
        cartSum(state, data){
            state.cartSum = data
        },
        CouponCheck(state, data){
            if(data == 'Percent'){
                let discount = state.cartSum*localStorage.getItem('coupon_amount')*(1/100);
                state.couponAmount = parseInt(discount)
            }
            if(data == 'Fixed'){
                state.couponAmount = parseInt(localStorage.getItem('coupon_amount'))
            }
        },
        cartRemove(state, data){
            state.cart = data.cartItem
            state.cartSum = data.cartcount
            if(localStorage.getItem('coupon_type') == 'Perchent'){
                let discount = state.cartSum*localStorage.getItem('coupon_amount')*(1/100);
                state.couponAmount = parseInt(discount)
            }else if(localStorage.getItem('coupon_type') == 'Fixed'){
                state.couponAmount = parseInt(localStorage.getItem('coupon_amount'))
            }
        },
        cancelCoupon(state){
            state.couponAmount = 0
        },
        OrdersGet(state, data){
            state.orders = []
            state.orderNextPageUrl = data.data.next_page_url
            let fdata = data.data.data
            fdata.map((order)=>{
                state.orders.push(order)
            })
        },
        OrderStatusUpdate(state, orderID){
            state.orders.map((order)=>{
                if(order.id == orderID.value){
                    order.payment_status = 2
                }
            })
        },
        UserFirst(state, data){
            state.user = data
        },
        getCountry(state, data){
            state.country = data.country
            state.user = data.user
        },
        Loader(state, data){
            state.loader = data
        },
        mainPageLoader(state, data){
            state.mainPageLoader = data
        },
        Setting(state, data){
            state.settings = data
        },
        UserLogged(state, data){
            state.UserLogged = data
        },
        SearchProduct(state, {data, searchProdNextUrl, parentProduct}){
            state.SearchProduct = data
            state.nextSearchUrl = searchProdNextUrl
            state.parentProduct = parentProduct
        },
        MoreSearchProduct(state, {data, searchProdNextUrl, parentProduct}){
            data.map((prod, index)=>{
                state.SearchProduct.push(prod)
                state.parentProduct.push(parentProduct[index])
            })
            state.nextSearchUrl = searchProdNextUrl
        },
        noSearchProduct(state){
            state.SearchLoader = false
            state.SearchProduct = []
            state.nextSearchUrl = []
            state.parentProduct = []
        },
        SearchText(state, data){
            state.SearchText = data
        },
        SearchLoader(state, data){
            state.SearchLoader = data
        },
        mainPage(state, data){
            state.mainPage = data
        },
        mobileMenuHideShow(state, data){
            if(data == true && state.LeftCategorySidebar == true){
                state.LeftCategorySidebar = false
            }
            state.mobileMenuHideShow = data
        },
        LeftCategorySidebar(state, data){
            if(data == true && state.mobileMenuHideShow == true){
                state.mobileMenuHideShow = false
            }
            state.LeftCategorySidebar = data
        },
        rightSidebar(state, data){
            state.rightSidebar = data
        },
        rightCompare(state, data){
            state.rightCompare = data
        },
        SubNavClose(state, data){
            state.SubNavClose = data
        },
        MainNav(state, data){
            state.MainNav = data
        },
        subNavData(state, data){
            state.subNavData = data
        },
        CurrentCategoryProductImage(state, [categoryProduct, categoryImage, NextPageUrl]){
            state.categoryProduct = categoryProduct
            state.categoryImage = categoryImage
            state.NextPageUrl = NextPageUrl
        },
        PushCurrentCategoryProductImage(state, [categoryProduct, categoryImage,NextPageUrl]){
            categoryProduct.map((p, index)=>{
                state.categoryProduct.push(p)
                state.categoryImage.push(categoryImage[index])
            })
            state.NextPageUrl = NextPageUrl
            // state.categoryProduct = categoryProduct
            // state.categoryImage = categoryImage
        },
        ReadyProductSection(state, [ReadyProducts,ReadyProductNextPage,ReadyProductImage]){
            state.ReadyProducts = ReadyProducts
            state.ReadyProductNextPage = ReadyProductNextPage
            state.ReadyProductImage = ReadyProductImage
        },
        SampleProductSection(state, [SampleProducts,SampleProductNextPage,SampleProductImage]){
            state.SampleProducts = SampleProducts
            state.SampleProductNextPage = SampleProductNextPage
            state.SampleProductImage = SampleProductImage
        },
        CategoryLoader(state, data){
            state.CategoryLoader = data
        },
        CartQuantity(state, [quantity, index]){
            state.cart.map((c, cindex)=>{
                if(cindex == index){
                    c.quantity = quantity
                    c.total_price = c.product_price * quantity
                }
            })
        },
        CartDelete(state, data){
            state.cart.map((p, index,  farr)=>{
                if(p.id == data){
                    state.cartSum = parseFloat(state.cartSum) - parseFloat(p.total_price)
                    farr.splice(index, 1)
                }
            })
        },
        DeleteCompare(state, index){
            state.compare.map((p, iindex,  farr)=>{
                if(index == iindex){
                    farr.splice(iindex, 1)
                }
            })
        },
        CartSumAdd(state, [catId, TotalPrice]){
            state.cartSum = parseFloat(TotalPrice)
        },
        cartNull(state){
            state.cart = []
            state.cartSum = 0
        },
        CartCompare(state, data){
            state.CartCompare = data
        },
        SearchValue(state, [searchvalue, searchStock]){
            state.SearchText= searchvalue
            state.SearchProduct = []
            state.SearchProductImage = []
            axios.post('/api/search-text/'+searchvalue+'/'+searchStock).then(response => {
                console.log(response.data)
                state.SearchProduct = response.data.data.data
                state.nextSearchUrl = response.data.data.next_page_url
                state.SearchProductImage = response.data.SearchProductImage
            })
        },
        searchNull(state, data){
            state.SearchText = ''
        },
        SearchNextUrl(state, data){
            state.SearchLoader = true
            axios.post(state.nextSearchUrl).then(response => {
                state.SearchLoader = false
                response.data.data.data.map((p, index)=>{
                    state.SearchProduct.push(p)
                    state.SearchProductImage.push(response.data.SearchProductImage[index])
                })
                state.nextSearchUrl = response.data.data.next_page_url
            })
        },
        hotProducts(state, data){
            state.hot_product = data
        },
        categorySlug(state, data){
            state.categorySlug = data
        },
        ReadyProductNextPageUrl(state, data){
            state.ReadyProductNextPage = data
        },
        SampleProductNextPageUrl(state, data){
            state.SampleProductNextPage = data
        },
        HomeSlider(state, data){
            state.homeSlider = data
        },
        HeaderFooterOff(state, data){
            state.HeaderFooterOff = data
        },
        HeaderSearchBar(state, data){
            state.HeaderSearchbar = data
        },
        searchInstock(state, data){
            state.searchInstock = data
        },
        CurrentTab(state, data){
            state.CurrentTab = data
        },
        CurrentOrderId(state, data){
            state.CurrentOrderId = data
        }
    },
    actions: {
        Homepage({commit}, data){
            commit('Homepage', data)
        },
        Products({commit}, data){
            commit('Products', data)
        },
        colorChanges({commit}, id){
            commit('colorChanges', id)
        },
        cartItem({commit, state}, data){
            axios.post('/api/cartitem/'+data).then(response => {
                commit('cartItem', response.data)
            })
        },
        addCart({commit}, data){
            commit('addCart', data)
        },
        addCompare({commit}, data){
            commit('addCompare', data)
        },
        cartRemove({commit, state}, data){
            if(localStorage.getItem('authToken')){
                let AuthTokenId = localStorage.getItem('authToken').split('|')[0]
                axios.post('/api/cart-remove/'+data+'/'+AuthTokenId).then(response => {
                    commit('cartRemove', response.data)
                })
            }else{
                axios.post('/api/cart-remove/'+data+'/'+localStorage.getItem('defaultToken')).then(response => {
                    commit('cartRemove', response.data)
                })
            }
        },
        SizeColor({commit}, data){
            commit('SizeColor', data)
        },
        cartSum({commit}, data){
            commit('cartSum', data)
        },
        CouponCheck({commit}, data){
            commit('CouponCheck', data)
        },
        cancelCoupon({commit}){
            commit('cancelCoupon')
        },
        OrdersGet({commit}, data){
            commit('OrdersGet', data)
        },
        OrderStatusUpdate({commit}, orderID){
            commit('OrderStatusUpdate',orderID)
        },
        UserFirst({commit}, data){
            commit('UserFirst', data)
        },
        getCountry({commit}, data){
            commit('getCountry', data)
        },
        Loader({commit}, data){
            commit('Loader', data)
        },
        mainPageLoader({commit}, data){
            commit('mainPageLoader', data)
        },
        Setting({commit}, data){
            commit('Setting', data)
        },
        UserLogged({commit}, data){
            commit('UserLogged', data)
        },
        SearchProduct({commit}, {data, searchProdNextUrl, parentProduct}){
            commit('SearchProduct', {data, searchProdNextUrl, parentProduct})
        },
        MoreSearchProduct({commit}, {data, searchProdNextUrl, parentProduct}){
            commit('MoreSearchProduct', {data, searchProdNextUrl, parentProduct})
        },
        noSearchProduct({commit}){
            commit('noSearchProduct')
        },
        SearchText({commit}, data){
            commit('SearchText', data)
        },
        SearchLoader({commit}, data){
            commit('SearchLoader', data)
        },
        mainPage({commit}, data){
            commit('mainPage', data)
        },
        mobileMenuHideShow({commit}, data){
            commit('mobileMenuHideShow', data)
        },
        LeftCategorySidebar({commit}, data){
            commit('LeftCategorySidebar', data)
        },
        rightSidebar({commit}, data){
            commit('rightSidebar', data)
        },
        rightCompare({commit}, data){
            commit('rightCompare', data)
        },
        SubNavClose({commit},data){
            commit('SubNavClose',data)
        },
        MainNav({commit},data){
            commit('MainNav',data)
        },
        subNavData({commit},data){
            commit('subNavData',data)
        },
        CurrentCategoryProductImage({commit},[categoryProduct, categoryImage, NextPageUrl]){
            commit('CurrentCategoryProductImage',[categoryProduct, categoryImage,NextPageUrl])
        },
        PushCurrentCategoryProductImage({commit},[categoryProduct, categoryImage,NextPageUrl]){
            commit('PushCurrentCategoryProductImage',[categoryProduct, categoryImage,NextPageUrl])
        },
        ReadyProductSection({commit}, [ReadyProducts,ReadyProductNextPage,ReadyProductImage]){
            commit('ReadyProductSection',[ReadyProducts,ReadyProductNextPage,ReadyProductImage])
        },
        SampleProductSection({commit}, [SampleProducts,SampleProductNextPage,SampleProductImage]){
            commit('SampleProductSection',[SampleProducts,SampleProductNextPage,SampleProductImage])
        },
        CategoryLoader({commit},data){
            commit('CategoryLoader',data)
        },
        CartQuantity({commit},[quantity, index]){
            commit('CartQuantity', [quantity, index])
        },
        CartDelete({commit}, data){
            commit('CartDelete',data)
        },
        CartSumAdd({commit},[catId, TotalPrice]){
            commit('CartSumAdd',[catId, TotalPrice])
        },
        cartNull({commit}){
            commit('cartNull')
        },
        DeleteCompare({commit}, index){
            commit('DeleteCompare',index)
        },
        CartCompare({commit}, data){
            commit('CartCompare',data)
        },
        SearchValue({commit},[searchvalue, searchStock]){
            commit('SearchValue',[searchvalue, searchStock])
        },
        searchNull({commit},data){
            commit('searchNull',data)
        },
        SearchNextUrl({commit},data){
            commit('SearchNextUrl',data)
        },
        hotProducts({commit},data){
            commit('hotProducts',data)
        },
        categorySlug({commit},data){
            commit('categorySlug',data)
        },
        ReadyProductNextPageUrl({commit},data){
            commit('ReadyProductNextPageUrl',data)
        },
        SampleProductNextPageUrl({commit},data){
            commit('SampleProductNextPageUrl',data)
        },
        HomeSlider({commit},data){
            commit('HomeSlider',data)
        },
        HeaderFooterOff({commit},data){
            commit('HeaderFooterOff',data)
        },
        HeaderSearchBar({commit}, data){
            commit('HeaderSearchBar', data)
        },
        searchInstock({commit}, data){
            commit('searchInstock',data)
        },
        CurrentTab({commit},data){
            commit('CurrentTab',data)
        },
        CurrentOrderId({commit},data){
            commit('CurrentOrderId',data)
        }
    },
    getters:{
    },
    modules: {

    }
})
