<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>My Location to Target (FREE)</title>

    <link
      rel="stylesheet"
      href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css"
    />

    <style>
        #map {
            height: 550px;
            width: 100%;
        }
    </style>
</head>
<body>

<h2 style="text-align:center">📍 My Location → Target Location</h2>

<div id="map"></div>

<script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js"></script>

<script>
    // 🎯 Target / Specific Location (example: customer location)
    const targetLocation = {
        lat: 23.7465,  // change this
        lng: 90.3760   // change this
    };

    // 🗺️ Map Init
    const map = L.map('map').setView([23.8103, 90.4125], 7);

    // 🟢 Free OpenStreetMap
    L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
        attribution: '© OpenStreetMap contributors'
    }).addTo(map);

    // 🎯 Target Marker
    const targetMarker = L.marker([targetLocation.lat, targetLocation.lng])
        .addTo(map)
        .bindPopup("🎯 Target Location")
        .openPopup();

    // 📍 Get My Current Location (Browser GPS)
    if (navigator.geolocation) {
        navigator.geolocation.getCurrentPosition(
            (position) => {
                const myLat = position.coords.latitude;
                const myLng = position.coords.longitude;

                // My location marker
                const myMarker = L.marker([myLat, myLng])
                    .addTo(map)
                    .bindPopup("📍 My Location")
                    .openPopup();

                // 🔵 Line between my location & target
                const routeLine = L.polyline([
                    [myLat, myLng],
                    [targetLocation.lat, targetLocation.lng]
                ], {
                    color: 'blue',
                    weight: 4
                }).addTo(map);

                // Auto zoom to fit both points
                map.fitBounds(routeLine.getBounds());
            },
            () => {
                alert('Location access denied!');
            }
        );
    } else {
        alert('Geolocation not supported');
    }
</script>

</body>
</html>
