<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\api\HomeController;
use App\Http\Controllers\api\CartController;
use App\Http\Controllers\api\HeaderController;
use App\Http\Controllers\api\CategoryController;
use App\Http\Controllers\api\CompareController;
use App\Http\Controllers\PageController;
use App\Http\Controllers\api\CheckoutController;
use App\Http\Controllers\api\QuoteController;
use App\Http\Controllers\api\UserController;

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});


Route::match(['get','post'], '/title-check',[\App\Http\Controllers\api\TitleController::class, 'titleGet'])->name('titleGet');
Route::match(['get','post'], '/product-check/{product_code}/{product_name}',[\App\Http\Controllers\api\ProductController::class, 'ProductCheck']);
Route::match(['get','post'], '/all-category-product',[\App\Http\Controllers\api\ProductController::class, 'AllCategoryProduct']);

Route::match(['get','post'], '/hot-selling-product',[\App\Http\Controllers\api\ProductController::class, 'HotSellingProduct']);

Route::match(['get','post'], '/cat-check/{cat_name}',[\App\Http\Controllers\api\ProductController::class, 'CatCheck']);
Route::match(['get','post'], '/product-details/{productCode}',[\App\Http\Controllers\api\ProductController::class, 'ProductDetailPage']);
Route::match(['get','post'], '/related-product/{productCode}',[\App\Http\Controllers\api\ProductController::class, 'RelatedProduct']);

Route::match(['get','post'], '/product-details-page-product-variant/{prodctId}/{productVariantName}',[\App\Http\Controllers\api\ProductController::class, 'ProductDetailPageProductDetail']);
Route::match(['get','post'], '/product-wise-size',[\App\Http\Controllers\api\ProductController::class, 'ProductWiseSizePrice']);
Route::match(['get','post'], '/sample-page-product',[\App\Http\Controllers\api\ProductController::class, 'SamplePageProduct']);
Route::match(['get','post'], '/sample-page-product-category/{categoryId}',[\App\Http\Controllers\api\ProductController::class, 'SamplePageProductCategory']);
Route::match(['get','post'], '/order-details/{productId}',[\App\Http\Controllers\api\ProductController::class, 'OrderDetails']);




Route::match(['get','post'], '/home-page',[HomeController::class, 'HomePage']);

Route::match(['get','post'], '/home-page-ready/{sortBy}',[HomeController::class, 'HomePageReady']);
Route::match(['get','post'], '/home-page-sample/{sortBy}',[HomeController::class, 'HomePageSample']);
Route::match(['get','post'], '/cartitem/{session}',[CartController::class, 'CartItem']);
Route::match(['get','post'], '/cart-quantity-update/{quantity}/{id}',[CartController::class, 'CartQuantityUpdate']);
Route::match(['get','post'], '/delete-cart-item/{id}',[CartController::class, 'DeleteCartItem']);
Route::match(['get','post'], '/cart-quantity-check/{code}',[CartController::class, 'CartQuantityCheck']);



Route::match(['get','post'], '/add-to-cart-post/{quantity}/{productId}/{sku}/{token}',[CartController::class, 'AddtoCartPost']);


Route::match(['get','post'], '/forgot-password/{phone}',[\App\Http\Controllers\api\AuthController::class, 'forgotPassword'])->name('forgotPassword');
Route::match(['get','post'], '/change-password/{phone}',[\App\Http\Controllers\api\AuthController::class, 'changePassword'])->name('changePassword');
Route::match(['get','post'], '/user-change-password',[\App\Http\Controllers\api\AuthController::class, 'userChangePassword'])->name('userChangePassword');
Route::match(['get','post'], '/user-signup',[\App\Http\Controllers\api\AuthController::class, 'userSignUp'])->name('userSignUp');
Route::match(['get','post'], '/default-otp/{phone}',[\App\Http\Controllers\api\AuthController::class, 'defaultOTP'])->name('defaultOTP');
Route::match(['get','post'], '/confirm-verify-otp/{phone}',[\App\Http\Controllers\api\AuthController::class, 'confirmVerifyOTP'])->name('confirmVerifyOTP');
Route::match(['get','post'], '/latitude-longitude-add/{latitude}/{longitude}/{token}',[\App\Http\Controllers\api\AuthController::class, 'LatitudeLongitudeAdd'])->name('LatitudeLongitudeAdd');



Route::match(['get','post'], '/nav-bar-nav',[\App\Http\Controllers\api\HeaderController::class, 'NavBarNav']);


Route::match(['get','post'], '/check-main-category-product/{categoryId}/{currentASC}/{currentHighLow}',[\App\Http\Controllers\api\CategoryController::class, 'MainCategoryProduct']);
Route::match(['get','post'], '/check-sub-category-product/{categoryId}/{currentASC}/{currentHighLow}',[\App\Http\Controllers\api\CategoryController::class, 'SubCategoryProduct']);
Route::match(['get','post'], '/in-stock-product-get',[\App\Http\Controllers\api\CategoryController::class, 'InStockProductGet']);


// PageController
Route::match(['get','post'], '/all-page/{tableName}',[PageController::class, 'allPage'])->name('allPage');
Route::match(['get','post'], '/team-page/team-member',[PageController::class, 'teamMember'])->name('teamMember');
Route::match(['get','post'], '/contactpagesendmessage',[PageController::class, 'contactpagesendmessage'])->name('contactpagesendmessage');


Route::match(['get','post'], '/add-to-compare-post/{productId}/{session}',[CompareController::class, 'AddComparePost']);
Route::match(['get','post'], '/all-compare-get/{session}',[CompareController::class, 'AllCompareGet']);
Route::match(['get','post'], '/deleteCompare/{id}',[CompareController::class, 'DeleteCompare']);
Route::match(['get','post'], '/select-product-variant/{productId}',[\App\Http\Controllers\api\CompareController::class, 'SelectCompareVariant']);
Route::match(['get','post'], '/select-product-variant-size/{productId}',[\App\Http\Controllers\api\CompareController::class, 'SelectCompareVariantSize']);
Route::match(['get','post'], '/check-compare-product-code/{id}/{token}',[\App\Http\Controllers\api\CompareController::class, 'CheckCompareProductCode']);
Route::match(['get','post'], '/product-code-check/{productCodeCheck}',[\App\Http\Controllers\api\CompareController::class, 'ProductCodeCheck']);





Route::match(['get','post'], '/checkout-page/{token}',[CheckoutController::class, 'CheckOutPage']);
Route::match(['get','post'], '/add-order-checkout/{token}',[CheckoutController::class, 'AddOrderCheckout']);
Route::match(['get','post'], '/order-success-page-data/{token}/{id}',[CheckoutController::class, 'OrderSuccessPageData']);
Route::match(['get','post'], '/automatic-shipping/{userId}',[CheckoutController::class, 'AutomaticShippingChecking']);

Route::match(['get','post'], '/quote-form-page/{token}/{sku}',[QuoteController::class, 'QuoteFormPage']);
Route::match(['get','post'], '/add-quote-post/{sku}',[QuoteController::class, 'AddQuotePost']);
Route::match(['get','post'], '/upload-quota-data',[QuoteController::class, 'UploadQuotaFormFile']);

// OrderController

Route::match(['get','post'], '/get-orders/{tokenId}',[\App\Http\Controllers\api\OrderController::class, 'getOrders']);

Route::match(['get','post'], '/orderProduct/{orderId}',[\App\Http\Controllers\api\OrderController::class, 'orderProductGet']);


Route::match(['get','post'], '/get-address/{tokenId}',[\App\Http\Controllers\api\AddressController::class, 'getAddress']);

Route::match(['get','post'], '/user-update',[\App\Http\Controllers\api\AuthController::class, 'UserUpdate'])->name('UserUpdate');
Route::match(['get','post'], '/update-profile-picture',[\App\Http\Controllers\api\AuthController::class, 'updateProfilePicture']);


Route::match(['get','post'], '/search-text/{data}/{stockCheck}',[\App\Http\Controllers\api\SearchController::class, 'SearchText']);
Route::match(['get','post'], '/clients-page-get/{data}',[\App\Http\Controllers\api\FooterController::class, 'ClientsGet']);

Route::match(['get','post'], '/send-otp-message/{phone}',[\App\Http\Controllers\api\OTPController::class, 'sendotpMessage']);

