<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Distance Calculator (FREE)</title>

    <link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css" />

    <style>
        #map { height: 800px; width: 100%; }
        .distance-info {
            background: white; padding: 10px;
            border-radius: 5px; border: 2px solid #3388ff;
            font-weight: bold;
        }
    </style>
</head>
<body>

<h2 style="text-align:center">📍 My Location → Target (Distance Check)</h2>
<div id="map"></div>

<script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js"></script>

<script>
    // 🎯 টার্গেট লোকেশন (কাস্টমারের অবস্থান)
    const targetLocation = {
        lat: 22.690635,
        lng: 90.653756
    };

    // 🗺️ ম্যাপ ইনিশিয়ালাইজেশন
    const map = L.map('map').setView([22.683410, 90.645748], 13);

    // 🟢 গুগল ম্যাপস রোড ভিউ ব্যবহার করা হয়েছে (আপনার পছন্দ অনুযায়ী)
    L.tileLayer('http://{s}.google.com/vt/lyrs=m&x={x}&y={y}&z={z}', {
        maxZoom: 20,
        subdomains: ['mt0', 'mt1', 'mt2', 'mt3'],
        attribution: '© Google Maps'
    }).addTo(map);

    // টার্গেট মার্কার
    const targetMarker = L.marker([targetLocation.lat, targetLocation.lng])
        .addTo(map)
        .bindPopup("🎯 কাস্টমার লোকেশন");

    // 📍 আমার বর্তমান লোকেশন চেক
    if (navigator.geolocation) {
        navigator.geolocation.getCurrentPosition(
            (position) => {
                const myLat = position.coords.latitude;
                const myLng = position.coords.longitude;

                const myPoint = L.latLng(myLat, myLng);
                const targetPoint = L.latLng(targetLocation.lat, targetLocation.lng);

                // 📏 দূরত্ব ক্যালকুলেশন (মিটার থেকে কিলোমিটারে রূপান্তর)
                const distanceInMeters = myPoint.distanceTo(targetPoint);
                const distanceInKm = (distanceInMeters / 1000).toFixed(2); // ২ দশমিক পর্যন্ত

                // আমার লোকেশন মার্কার
                L.marker([myLat, myLng]).addTo(map)
                    .bindPopup(`📍 আমার অবস্থান<br><b>দূরত্ব: ${distanceInKm} কি.মি.</b>`)
                    .openPopup();

                // 🔵 দুই পয়েন্টের মধ্যে দাগ (Line)
                const routeLine = L.polyline([
                    [myLat, myLng],
                    [targetLocation.lat, targetLocation.lng]
                ], {
                    color: '#ff4444',
                    weight: 5,
                    dashArray: '10, 10' // ডটেড লাইন
                }).addTo(map);

                // লাইনের মাঝখানে দূরত্ব দেখানোর জন্য একটি পপআপ
                routeLine.bindTooltip(`${distanceInKm} KM`, {
                    permanent: true,
                    direction: 'center',
                    className: 'distance-info'
                }).openTooltip();

                // অটো জুম জেনো দুই পয়েন্ট দেখা যায়
                map.fitBounds(routeLine.getBounds(), { padding: [50, 50] });
            },
            () => { alert('লোকেশনে প্রবেশের অনুমতি নেই!'); }
        );
    } else {
        alert('আপনার ব্রাউজারটি জিওলোকেশন সাপোর্ট করে না');
    }
</script>

</body>
</html><?php /**PATH C:\xampp\htdocs\amar bhola shop\resources\views/map/customer_location.blade.php ENDPATH**/ ?>